#property copyright "ClusterDelta"
#property link      "https://clusterdelta.com"
#property version   "1.00"

#property indicator_chart_window
#property indicator_plots 0

#include <Trade\Trade.mqh>

input string Description = "-- Example of fetching data via iCustom";
double MaximumRisk        = 0.02;    // Maximum Risk in percentage
double DecreaseFactor     = 3;       // Descrease factor

//---
int    ExtHandle=0;
bool   ExtHedging=false;
CTrade ExtTrade;

int VD_EA;
double Volumes[], Delta[];


#define EA_MAGIC 156234
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(void)
  {
//--- prepare trade class to control positions if hedging mode is active
   ExtHedging=((ENUM_ACCOUNT_MARGIN_MODE)AccountInfoInteger(ACCOUNT_MARGIN_MODE)==ACCOUNT_MARGIN_MODE_RETAIL_HEDGING);
   ExtTrade.SetExpertMagicNumber(EA_MAGIC);
   ExtTrade.SetMarginMode();
   ExtTrade.SetTypeFillingBySymbol(Symbol());
//--- VolumesDelta indicator
   VD_EA = iCustom(_Symbol,_Period,"#Volume_Delta_EA_iCustom");

   if(VD_EA==INVALID_HANDLE)
     {
      printf("Error attaching Volume/Delta indicator");
      return(INIT_FAILED);
     }
//--- ok
   
   EventSetMillisecondTimer(1000); // check situation each second
   return(INIT_SUCCEEDED);
  }

void OnTimer()
{
   EA_Calculations();
   return;
}

int TotalBars=0; // OnCalculate 

void EA_Calculations()
{
   if(TotalBars==0) return;
   datetime LastTime[];
   
   //if(CopyTime(NULL,PERIOD_CURRENT,0,1,LastTime)<=0) return; // Copy only last known time to LastTime[0]

   if(CopyTime(NULL,PERIOD_CURRENT,0,TotalBars,LastTime)<=0) return; // Copy all data to syncronize with Volumes and Delta
   if(CopyBuffer(VD_EA,0,0,TotalBars,Volumes)<=0) { Print ("Volumes not loaded yet"); return;  } // Buffer "0" is Volume
   if(CopyBuffer(VD_EA,2,0,TotalBars,Delta)<=0) { Print ("Delta not loaded yet"); return;  } // Buffer "2" is Delta for MT5 and "1" for MT4
   
   Print("last bar index: ",TotalBars-1, ", time: ",TimeToString(LastTime[TotalBars-1])," Volume: ", Volumes[TotalBars-1], ", Delta: ", Delta[TotalBars-1] );

}



//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total, 
                const int prev_calculated, 
                const datetime &time[], 
                const double &open[], 
                const double &high[], 
                const double &low[], 
                const double &close[], 
                const long &tick_volume[], 
                const long &volume[], 
                const int &spread[]) 
  { 
   
   TotalBars = rates_total;

   if(SelectPosition())
      CheckForClose();
   else
      CheckForOpen();


   return(rates_total); 
  } 
  

//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
  }
//+------------------------------------------------------------------+















// CODE REMAINING FROM THE MA EA EXAMPLE FROM THE METAQOUTES EXAMPLES


//+------------------------------------------------------------------+
//| Calculate optimal lot size                                       |
//+------------------------------------------------------------------+
double TradeSizeOptimized(void)
  {
   double price=0.0;
   double margin=0.0;
//--- select lot size
   if(!SymbolInfoDouble(_Symbol,SYMBOL_ASK,price))
      return(0.0);
   if(!OrderCalcMargin(ORDER_TYPE_BUY,_Symbol,1.0,price,margin))
      return(0.0);
   if(margin<=0.0)
      return(0.0);

   double lot=NormalizeDouble(AccountInfoDouble(ACCOUNT_MARGIN_FREE)*MaximumRisk/margin,2);
//--- calculate number of losses orders without a break
   if(DecreaseFactor>0)
     {
      //--- select history for access
      HistorySelect(0,TimeCurrent());
      //---
      int    orders=HistoryDealsTotal();  // total history deals
      int    losses=0;                    // number of losses orders without a break

      for(int i=orders-1;i>=0;i--)
        {
         ulong ticket=HistoryDealGetTicket(i);
         if(ticket==0)
           {
            Print("HistoryDealGetTicket failed, no trade history");
            break;
           }
         //--- check symbol
         if(HistoryDealGetString(ticket,DEAL_SYMBOL)!=_Symbol)
            continue;
         //--- check Expert Magic number
         if(HistoryDealGetInteger(ticket,DEAL_MAGIC)!=EA_MAGIC)
            continue;
         //--- check profit
         double profit=HistoryDealGetDouble(ticket,DEAL_PROFIT);
         if(profit>0.0)
            break;
         if(profit<0.0)
            losses++;
        }
      //---
      if(losses>1)
         lot=NormalizeDouble(lot-lot*losses/DecreaseFactor,1);
     }
//--- normalize and check limits
   double stepvol=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_STEP);
   lot=stepvol*NormalizeDouble(lot/stepvol,0);

   double minvol=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);
   if(lot<minvol)
      lot=minvol;

   double maxvol=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MAX);
   if(lot>maxvol)
      lot=maxvol;
//--- return trading volume
   return(lot);
  }
//+------------------------------------------------------------------+
//| Check for open position conditions                               |
//+------------------------------------------------------------------+
void CheckForOpen(void)
  {
 
  }
//+------------------------------------------------------------------+
//| Check for close position conditions                              |
//+------------------------------------------------------------------+
void CheckForClose(void)
  {

  }
//+------------------------------------------------------------------+
//| Position select depending on netting or hedging                  |
//+------------------------------------------------------------------+
bool SelectPosition()
  {
   bool res=false;
//--- check position in Hedging mode
   if(ExtHedging)
     {
      uint total=PositionsTotal();
      for(uint i=0; i<total; i++)
        {
         string position_symbol=PositionGetSymbol(i);
         if(_Symbol==position_symbol && EA_MAGIC==PositionGetInteger(POSITION_MAGIC))
           {
            res=true;
            break;
           }
        }
     }
//--- check position in Netting mode
   else
     {
      if(!PositionSelect(_Symbol))
         return(false);
      else
         return(PositionGetInteger(POSITION_MAGIC)==EA_MAGIC); //---check Magic number
     }
//--- result for Hedging mode
   return(res);
  }
