#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private ClusterDelta.ClusterDeltaAskBid[] cacheClusterDeltaAskBid;
		private ClusterDelta.ClusterDeltaBookmap[] cacheClusterDeltaBookmap;
		private ClusterDelta.ClusterDeltaCumDelta[] cacheClusterDeltaCumDelta;
		private ClusterDelta.ClusterDeltaCumDeltaChart[] cacheClusterDeltaCumDeltaChart;
		private ClusterDelta.ClusterDeltaDelta[] cacheClusterDeltaDelta;
		private ClusterDelta.ClusterDeltaDPOC[] cacheClusterDeltaDPOC;
		private ClusterDelta.ClusterDeltaFootPrint[] cacheClusterDeltaFootPrint;
		private ClusterDelta.ClusterDeltaImbalance[] cacheClusterDeltaImbalance;
		private ClusterDelta.ClusterDeltaInfusion[] cacheClusterDeltaInfusion;
		private ClusterDelta.ClusterDeltaMarketProfile[] cacheClusterDeltaMarketProfile;
		private ClusterDelta.ClusterDeltaSplash[] cacheClusterDeltaSplash;
		private ClusterDelta.ClusterDeltaVolume[] cacheClusterDeltaVolume;
		private ClusterDelta.ClusterDeltaVWAP[] cacheClusterDeltaVWAP;

		
		public ClusterDelta.ClusterDeltaAskBid ClusterDeltaAskBid(bool gui)
		{
			return ClusterDeltaAskBid(Input, gui);
		}

		public ClusterDelta.ClusterDeltaBookmap ClusterDeltaBookmap(int daysToLoad)
		{
			return ClusterDeltaBookmap(Input, daysToLoad);
		}

		public ClusterDelta.ClusterDeltaCumDelta ClusterDeltaCumDelta(bool gui)
		{
			return ClusterDeltaCumDelta(Input, gui);
		}

		public ClusterDelta.ClusterDeltaCumDeltaChart ClusterDeltaCumDeltaChart(bool gui)
		{
			return ClusterDeltaCumDeltaChart(Input, gui);
		}

		public ClusterDelta.ClusterDeltaDelta ClusterDeltaDelta(bool gui)
		{
			return ClusterDeltaDelta(Input, gui);
		}

		public ClusterDelta.ClusterDeltaDPOC ClusterDeltaDPOC(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods dPOC_Period_Value)
		{
			return ClusterDeltaDPOC(Input, dPOC_Period_Value);
		}

		public ClusterDelta.ClusterDeltaFootPrint ClusterDeltaFootPrint(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.ChartFutures ninjaTraderInstrument_Value)
		{
			return ClusterDeltaFootPrint(Input, ninjaTraderInstrument_Value);
		}

		public ClusterDelta.ClusterDeltaImbalance ClusterDeltaImbalance(int daysToLoad)
		{
			return ClusterDeltaImbalance(Input, daysToLoad);
		}

		public ClusterDelta.ClusterDeltaInfusion ClusterDeltaInfusion(int daysToLoad)
		{
			return ClusterDeltaInfusion(Input, daysToLoad);
		}

		public ClusterDelta.ClusterDeltaMarketProfile ClusterDeltaMarketProfile(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods marketProfile_Period_Value)
		{
			return ClusterDeltaMarketProfile(Input, marketProfile_Period_Value);
		}

		public ClusterDelta.ClusterDeltaSplash ClusterDeltaSplash(ClusterDelta_Splash_AggregateTicks tickAggregate_Mode)
		{
			return ClusterDeltaSplash(Input, tickAggregate_Mode);
		}

		public ClusterDelta.ClusterDeltaVolume ClusterDeltaVolume(bool gui)
		{
			return ClusterDeltaVolume(Input, gui);
		}

		public ClusterDelta.ClusterDeltaVWAP ClusterDeltaVWAP(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods vWAP_Period_Value)
		{
			return ClusterDeltaVWAP(Input, vWAP_Period_Value);
		}


		
		public ClusterDelta.ClusterDeltaAskBid ClusterDeltaAskBid(ISeries<double> input, bool gui)
		{
			if (cacheClusterDeltaAskBid != null)
				for (int idx = 0; idx < cacheClusterDeltaAskBid.Length; idx++)
					if (cacheClusterDeltaAskBid[idx].Gui == gui && cacheClusterDeltaAskBid[idx].EqualsInput(input))
						return cacheClusterDeltaAskBid[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaAskBid>(new ClusterDelta.ClusterDeltaAskBid(){ Gui = gui }, input, ref cacheClusterDeltaAskBid);
		}

		public ClusterDelta.ClusterDeltaBookmap ClusterDeltaBookmap(ISeries<double> input, int daysToLoad)
		{
			if (cacheClusterDeltaBookmap != null)
				for (int idx = 0; idx < cacheClusterDeltaBookmap.Length; idx++)
					if (cacheClusterDeltaBookmap[idx].DaysToLoad == daysToLoad && cacheClusterDeltaBookmap[idx].EqualsInput(input))
						return cacheClusterDeltaBookmap[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaBookmap>(new ClusterDelta.ClusterDeltaBookmap(){ DaysToLoad = daysToLoad }, input, ref cacheClusterDeltaBookmap);
		}

		public ClusterDelta.ClusterDeltaCumDelta ClusterDeltaCumDelta(ISeries<double> input, bool gui)
		{
			if (cacheClusterDeltaCumDelta != null)
				for (int idx = 0; idx < cacheClusterDeltaCumDelta.Length; idx++)
					if (cacheClusterDeltaCumDelta[idx].Gui == gui && cacheClusterDeltaCumDelta[idx].EqualsInput(input))
						return cacheClusterDeltaCumDelta[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaCumDelta>(new ClusterDelta.ClusterDeltaCumDelta(){ Gui = gui }, input, ref cacheClusterDeltaCumDelta);
		}

		public ClusterDelta.ClusterDeltaCumDeltaChart ClusterDeltaCumDeltaChart(ISeries<double> input, bool gui)
		{
			if (cacheClusterDeltaCumDeltaChart != null)
				for (int idx = 0; idx < cacheClusterDeltaCumDeltaChart.Length; idx++)
					if (cacheClusterDeltaCumDeltaChart[idx].Gui == gui && cacheClusterDeltaCumDeltaChart[idx].EqualsInput(input))
						return cacheClusterDeltaCumDeltaChart[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaCumDeltaChart>(new ClusterDelta.ClusterDeltaCumDeltaChart(){ Gui = gui }, input, ref cacheClusterDeltaCumDeltaChart);
		}

		public ClusterDelta.ClusterDeltaDelta ClusterDeltaDelta(ISeries<double> input, bool gui)
		{
			if (cacheClusterDeltaDelta != null)
				for (int idx = 0; idx < cacheClusterDeltaDelta.Length; idx++)
					if (cacheClusterDeltaDelta[idx].Gui == gui && cacheClusterDeltaDelta[idx].EqualsInput(input))
						return cacheClusterDeltaDelta[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaDelta>(new ClusterDelta.ClusterDeltaDelta(){ Gui = gui }, input, ref cacheClusterDeltaDelta);
		}

		public ClusterDelta.ClusterDeltaDPOC ClusterDeltaDPOC(ISeries<double> input, NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods dPOC_Period_Value)
		{
			if (cacheClusterDeltaDPOC != null)
				for (int idx = 0; idx < cacheClusterDeltaDPOC.Length; idx++)
					if (cacheClusterDeltaDPOC[idx].DPOC_Period_Value == dPOC_Period_Value && cacheClusterDeltaDPOC[idx].EqualsInput(input))
						return cacheClusterDeltaDPOC[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaDPOC>(new ClusterDelta.ClusterDeltaDPOC(){ DPOC_Period_Value = dPOC_Period_Value }, input, ref cacheClusterDeltaDPOC);
		}

		public ClusterDelta.ClusterDeltaFootPrint ClusterDeltaFootPrint(ISeries<double> input, NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.ChartFutures ninjaTraderInstrument_Value)
		{
			if (cacheClusterDeltaFootPrint != null)
				for (int idx = 0; idx < cacheClusterDeltaFootPrint.Length; idx++)
					if (cacheClusterDeltaFootPrint[idx].NinjaTraderInstrument_Value == ninjaTraderInstrument_Value && cacheClusterDeltaFootPrint[idx].EqualsInput(input))
						return cacheClusterDeltaFootPrint[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaFootPrint>(new ClusterDelta.ClusterDeltaFootPrint(){ NinjaTraderInstrument_Value = ninjaTraderInstrument_Value }, input, ref cacheClusterDeltaFootPrint);
		}

		public ClusterDelta.ClusterDeltaImbalance ClusterDeltaImbalance(ISeries<double> input, int daysToLoad)
		{
			if (cacheClusterDeltaImbalance != null)
				for (int idx = 0; idx < cacheClusterDeltaImbalance.Length; idx++)
					if (cacheClusterDeltaImbalance[idx].DaysToLoad == daysToLoad && cacheClusterDeltaImbalance[idx].EqualsInput(input))
						return cacheClusterDeltaImbalance[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaImbalance>(new ClusterDelta.ClusterDeltaImbalance(){ DaysToLoad = daysToLoad }, input, ref cacheClusterDeltaImbalance);
		}

		public ClusterDelta.ClusterDeltaInfusion ClusterDeltaInfusion(ISeries<double> input, int daysToLoad)
		{
			if (cacheClusterDeltaInfusion != null)
				for (int idx = 0; idx < cacheClusterDeltaInfusion.Length; idx++)
					if (cacheClusterDeltaInfusion[idx].DaysToLoad == daysToLoad && cacheClusterDeltaInfusion[idx].EqualsInput(input))
						return cacheClusterDeltaInfusion[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaInfusion>(new ClusterDelta.ClusterDeltaInfusion(){ DaysToLoad = daysToLoad }, input, ref cacheClusterDeltaInfusion);
		}

		public ClusterDelta.ClusterDeltaMarketProfile ClusterDeltaMarketProfile(ISeries<double> input, NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods marketProfile_Period_Value)
		{
			if (cacheClusterDeltaMarketProfile != null)
				for (int idx = 0; idx < cacheClusterDeltaMarketProfile.Length; idx++)
					if (cacheClusterDeltaMarketProfile[idx].MarketProfile_Period_Value == marketProfile_Period_Value && cacheClusterDeltaMarketProfile[idx].EqualsInput(input))
						return cacheClusterDeltaMarketProfile[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaMarketProfile>(new ClusterDelta.ClusterDeltaMarketProfile(){ MarketProfile_Period_Value = marketProfile_Period_Value }, input, ref cacheClusterDeltaMarketProfile);
		}

		public ClusterDelta.ClusterDeltaSplash ClusterDeltaSplash(ISeries<double> input, ClusterDelta_Splash_AggregateTicks tickAggregate_Mode)
		{
			if (cacheClusterDeltaSplash != null)
				for (int idx = 0; idx < cacheClusterDeltaSplash.Length; idx++)
					if (cacheClusterDeltaSplash[idx].TickAggregate_Mode == tickAggregate_Mode && cacheClusterDeltaSplash[idx].EqualsInput(input))
						return cacheClusterDeltaSplash[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaSplash>(new ClusterDelta.ClusterDeltaSplash(){ TickAggregate_Mode = tickAggregate_Mode }, input, ref cacheClusterDeltaSplash);
		}

		public ClusterDelta.ClusterDeltaVolume ClusterDeltaVolume(ISeries<double> input, bool gui)
		{
			if (cacheClusterDeltaVolume != null)
				for (int idx = 0; idx < cacheClusterDeltaVolume.Length; idx++)
					if (cacheClusterDeltaVolume[idx].Gui == gui && cacheClusterDeltaVolume[idx].EqualsInput(input))
						return cacheClusterDeltaVolume[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaVolume>(new ClusterDelta.ClusterDeltaVolume(){ Gui = gui }, input, ref cacheClusterDeltaVolume);
		}

		public ClusterDelta.ClusterDeltaVWAP ClusterDeltaVWAP(ISeries<double> input, NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods vWAP_Period_Value)
		{
			if (cacheClusterDeltaVWAP != null)
				for (int idx = 0; idx < cacheClusterDeltaVWAP.Length; idx++)
					if (cacheClusterDeltaVWAP[idx].VWAP_Period_Value == vWAP_Period_Value && cacheClusterDeltaVWAP[idx].EqualsInput(input))
						return cacheClusterDeltaVWAP[idx];
			return CacheIndicator<ClusterDelta.ClusterDeltaVWAP>(new ClusterDelta.ClusterDeltaVWAP(){ VWAP_Period_Value = vWAP_Period_Value }, input, ref cacheClusterDeltaVWAP);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.ClusterDelta.ClusterDeltaAskBid ClusterDeltaAskBid(bool gui)
		{
			return indicator.ClusterDeltaAskBid(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaBookmap ClusterDeltaBookmap(int daysToLoad)
		{
			return indicator.ClusterDeltaBookmap(Input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDelta ClusterDeltaCumDelta(bool gui)
		{
			return indicator.ClusterDeltaCumDelta(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDeltaChart ClusterDeltaCumDeltaChart(bool gui)
		{
			return indicator.ClusterDeltaCumDeltaChart(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDelta ClusterDeltaDelta(bool gui)
		{
			return indicator.ClusterDeltaDelta(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDPOC ClusterDeltaDPOC(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods dPOC_Period_Value)
		{
			return indicator.ClusterDeltaDPOC(Input, dPOC_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaFootPrint ClusterDeltaFootPrint(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.ChartFutures ninjaTraderInstrument_Value)
		{
			return indicator.ClusterDeltaFootPrint(Input, ninjaTraderInstrument_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaImbalance ClusterDeltaImbalance(int daysToLoad)
		{
			return indicator.ClusterDeltaImbalance(Input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaInfusion ClusterDeltaInfusion(int daysToLoad)
		{
			return indicator.ClusterDeltaInfusion(Input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaMarketProfile ClusterDeltaMarketProfile(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods marketProfile_Period_Value)
		{
			return indicator.ClusterDeltaMarketProfile(Input, marketProfile_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaSplash ClusterDeltaSplash(ClusterDelta_Splash_AggregateTicks tickAggregate_Mode)
		{
			return indicator.ClusterDeltaSplash(Input, tickAggregate_Mode);
		}

		public Indicators.ClusterDelta.ClusterDeltaVolume ClusterDeltaVolume(bool gui)
		{
			return indicator.ClusterDeltaVolume(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaVWAP ClusterDeltaVWAP(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods vWAP_Period_Value)
		{
			return indicator.ClusterDeltaVWAP(Input, vWAP_Period_Value);
		}


		
		public Indicators.ClusterDelta.ClusterDeltaAskBid ClusterDeltaAskBid(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaAskBid(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaBookmap ClusterDeltaBookmap(ISeries<double> input , int daysToLoad)
		{
			return indicator.ClusterDeltaBookmap(input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDelta ClusterDeltaCumDelta(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaCumDelta(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDeltaChart ClusterDeltaCumDeltaChart(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaCumDeltaChart(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDelta ClusterDeltaDelta(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaDelta(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDPOC ClusterDeltaDPOC(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods dPOC_Period_Value)
		{
			return indicator.ClusterDeltaDPOC(input, dPOC_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaFootPrint ClusterDeltaFootPrint(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.ChartFutures ninjaTraderInstrument_Value)
		{
			return indicator.ClusterDeltaFootPrint(input, ninjaTraderInstrument_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaImbalance ClusterDeltaImbalance(ISeries<double> input , int daysToLoad)
		{
			return indicator.ClusterDeltaImbalance(input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaInfusion ClusterDeltaInfusion(ISeries<double> input , int daysToLoad)
		{
			return indicator.ClusterDeltaInfusion(input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaMarketProfile ClusterDeltaMarketProfile(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods marketProfile_Period_Value)
		{
			return indicator.ClusterDeltaMarketProfile(input, marketProfile_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaSplash ClusterDeltaSplash(ISeries<double> input , ClusterDelta_Splash_AggregateTicks tickAggregate_Mode)
		{
			return indicator.ClusterDeltaSplash(input, tickAggregate_Mode);
		}

		public Indicators.ClusterDelta.ClusterDeltaVolume ClusterDeltaVolume(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaVolume(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaVWAP ClusterDeltaVWAP(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods vWAP_Period_Value)
		{
			return indicator.ClusterDeltaVWAP(input, vWAP_Period_Value);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.ClusterDelta.ClusterDeltaAskBid ClusterDeltaAskBid(bool gui)
		{
			return indicator.ClusterDeltaAskBid(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaBookmap ClusterDeltaBookmap(int daysToLoad)
		{
			return indicator.ClusterDeltaBookmap(Input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDelta ClusterDeltaCumDelta(bool gui)
		{
			return indicator.ClusterDeltaCumDelta(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDeltaChart ClusterDeltaCumDeltaChart(bool gui)
		{
			return indicator.ClusterDeltaCumDeltaChart(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDelta ClusterDeltaDelta(bool gui)
		{
			return indicator.ClusterDeltaDelta(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDPOC ClusterDeltaDPOC(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods dPOC_Period_Value)
		{
			return indicator.ClusterDeltaDPOC(Input, dPOC_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaFootPrint ClusterDeltaFootPrint(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.ChartFutures ninjaTraderInstrument_Value)
		{
			return indicator.ClusterDeltaFootPrint(Input, ninjaTraderInstrument_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaImbalance ClusterDeltaImbalance(int daysToLoad)
		{
			return indicator.ClusterDeltaImbalance(Input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaInfusion ClusterDeltaInfusion(int daysToLoad)
		{
			return indicator.ClusterDeltaInfusion(Input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaMarketProfile ClusterDeltaMarketProfile(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods marketProfile_Period_Value)
		{
			return indicator.ClusterDeltaMarketProfile(Input, marketProfile_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaSplash ClusterDeltaSplash(ClusterDelta_Splash_AggregateTicks tickAggregate_Mode)
		{
			return indicator.ClusterDeltaSplash(Input, tickAggregate_Mode);
		}

		public Indicators.ClusterDelta.ClusterDeltaVolume ClusterDeltaVolume(bool gui)
		{
			return indicator.ClusterDeltaVolume(Input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaVWAP ClusterDeltaVWAP(NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods vWAP_Period_Value)
		{
			return indicator.ClusterDeltaVWAP(Input, vWAP_Period_Value);
		}


		
		public Indicators.ClusterDelta.ClusterDeltaAskBid ClusterDeltaAskBid(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaAskBid(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaBookmap ClusterDeltaBookmap(ISeries<double> input , int daysToLoad)
		{
			return indicator.ClusterDeltaBookmap(input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDelta ClusterDeltaCumDelta(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaCumDelta(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaCumDeltaChart ClusterDeltaCumDeltaChart(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaCumDeltaChart(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDelta ClusterDeltaDelta(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaDelta(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaDPOC ClusterDeltaDPOC(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods dPOC_Period_Value)
		{
			return indicator.ClusterDeltaDPOC(input, dPOC_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaFootPrint ClusterDeltaFootPrint(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.ChartFutures ninjaTraderInstrument_Value)
		{
			return indicator.ClusterDeltaFootPrint(input, ninjaTraderInstrument_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaImbalance ClusterDeltaImbalance(ISeries<double> input , int daysToLoad)
		{
			return indicator.ClusterDeltaImbalance(input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaInfusion ClusterDeltaInfusion(ISeries<double> input , int daysToLoad)
		{
			return indicator.ClusterDeltaInfusion(input, daysToLoad);
		}

		public Indicators.ClusterDelta.ClusterDeltaMarketProfile ClusterDeltaMarketProfile(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods marketProfile_Period_Value)
		{
			return indicator.ClusterDeltaMarketProfile(input, marketProfile_Period_Value);
		}

		public Indicators.ClusterDelta.ClusterDeltaSplash ClusterDeltaSplash(ISeries<double> input , ClusterDelta_Splash_AggregateTicks tickAggregate_Mode)
		{
			return indicator.ClusterDeltaSplash(input, tickAggregate_Mode);
		}

		public Indicators.ClusterDelta.ClusterDeltaVolume ClusterDeltaVolume(ISeries<double> input , bool gui)
		{
			return indicator.ClusterDeltaVolume(input, gui);
		}

		public Indicators.ClusterDelta.ClusterDeltaVWAP ClusterDeltaVWAP(ISeries<double> input , NinjaTrader.NinjaScript.AddOns.ClusterDeltaTools.IndicatorBuildPeriods vWAP_Period_Value)
		{
			return indicator.ClusterDeltaVWAP(input, vWAP_Period_Value);
		}

	}
}

#endregion
